/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSemaphoreImpDrvNT.h,v 1.2 1999/09/17 04:20:51 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSemaphoreImpDrvNT_h	// [
#define Included_CSemaphoreImpDrvNT_h

#include "pgpClassesConfig.h"
#include "CSemaphoreImp.h"

_USING_PGP

// Class CSemaphoreImpDrvNT

class CSemaphoreImpDrvNT : public CSemaphoreImp
{
	friend class CPFLImpFactoryDrvNT;

private:
	CSemaphoreImpDrvNT();

public:
	~CSemaphoreImpDrvNT();

	PGPUInt32	Wait(PGPInt32 msTimeout);
	void		Signal(PGPUInt32 count);

private:
	KSEMAPHORE	mSemaphore;
};


// Class CSemaphoreImpDrvNT member functions

inline 
CSemaphoreImpDrvNT::CSemaphoreImpDrvNT()
{
	KeInitializeSemaphore(&mSemaphore, 0, 10000);
}

inline 
CSemaphoreImpDrvNT::~CSemaphoreImpDrvNT()
{
}

inline 
PGPUInt32 
CSemaphoreImpDrvNT::Wait(PGPInt32 msTimeout)
{
	LARGE_INTEGER	wait	= RtlConvertLongToLargeInteger(0 - 
		static_cast<PGPInt32>(msTimeout * PFLConstants::kHundredNsPerMs));

	if (msTimeout == CMutex::InfiniteTimeout)
	{
		return KeWaitForSingleObject(&mSemaphore, Executive, KernelMode, 
			FALSE, NULL);
	}
	else
	{
		return KeWaitForSingleObject(&mSemaphore, Executive, KernelMode, 
			FALSE, &wait);
	}
}

inline 
void 
CSemaphoreImpDrvNT::Signal(PGPUInt32 count)
{
	KeReleaseSemaphore(&mSemaphore, 0, count, FALSE);
}

#endif	// ] Included_CSemaphoreImpDrvNT_h
